-- MAXScript File
-- Created:  Aug 27 2008
-- Author:   Michael Russo
-- Support scripts for Modeling Ribbon
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK

-- Ribbon button callbacks
global RibbonDisplacementType = 1
global RibbonNURMSUpdateType = 1
global RibbonColorIllumSelectType = 1

--------------------------------------------------------------------
---
--- Ribbon_Modeling Helpers
---
--------------------------------------------------------------------
struct Ribbon_Modeling
(

-- get cached ManagedServices.SceneUtilities wrapper
fn GetCachedManagedServicesSceneUtilities =
(
	if (::Ribbon_Modeling_ManagedServices_SceneUtilities == undefined) then 
		::Ribbon_Modeling_ManagedServices_SceneUtilities = dotnetclass "ManagedServices.SceneUtilities"
	::Ribbon_Modeling_ManagedServices_SceneUtilities
),

-- for editable poly or edit poly in subobject mode
fn ValidSOMode =
(
	PolyBValidObject #SubobjectCheck #None
),

-- for editable poly or edit poly when also in subobjectlevel 0
fn ValidSelection =
(
	PolyBValidObject #NoSubobjectCheck #None
),

-- for editable poly or edit poly when also in subobjectlevel 0
fn ValidESplineSelection =
(
	local sceneUtils = Ribbon_Modeling.GetCachedManagedServicesSceneUtilities()
	(sceneUtils.IsSingleEditableSplineObjectSelected() or sceneUtils.IsSingleEditSplineModifierSelected())
),

-- check for edit poly mode
fn IsEditPolyMode =
(
	PolyBValidObject #NoSubobjectCheck #EditPolyModifier
),

-- check for editable poly
fn IsEditablePoly =
(
	PolyBValidObject #NoSubobjectCheck #EditablePoly
),

-- get SO Enum
fn GetSOEnum =
(
	SOEnum = #Object

	if subobjectlevel == 0 then
		SOEnum = #Object	
	else if subobjectlevel == 1 then
		SOEnum = #Vertex
	else if (subobjectlevel == 2) or (subobjectlevel == 3) then
		SOEnum = #Edge
	else
		SOEnum = #Face
	
	SOEnum
),

-- Is Edge SO Mode
fn IsEdgeMode =
(
	((subobjectlevel == 2) or (subobjectlevel == 3))
),

-- Is Face SO Mode
fn IsFaceMode =
(
	((subobjectlevel == 4) or (subobjectlevel ==5))
),

-- Vertex Panel title -- 
-- note:  needs to be localized -- 
fn SubObjectPanelTitle =
(
	if subobjectlevel == 0 or subobjectlevel == 1 then
		~VERTICES~
	else if subobjectlevel == 2 then
		~EDGES~
	else if subobjectlevel == 3 then
		~BORDERS~
	else if subobjectlevel == 4 then
		~POLYGONS~
	else if subobjectlevel == 5 then
		~ELEMENTS~
	else 
		~UNKNOWN~
),

fn SubobjectSwitch sublev =
(

	local sceneUtils = Ribbon_Modeling.GetCachedManagedServicesSceneUtilities()
	local keepGoing = true
	
	if (sublev > 0) do
	(
		local isEditPoly = sceneUtils.IsSingleEditablePolyObjectSelected()
		local isEditPolyMod = sceneUtils.IsSingleEditPolyModifierSelected()
		if not isEditPoly and not isEditPolyMod do
		(
			if not mcrUtils.ValidMod EditPolyMod
			then keepGoing = false
			else AddMod EditPolyMod
		)
	)
	
	if keepGoing do
	(
		if keyboard.controlpressed and subobjectlevel != 0 then
		(
			max modify mode
			curmod = Modpanel.getcurrentObject()
			local isShift =	keyboard.shiftpressed
			subarr = #(#Vertex, #Edge, #Border, #Face, #Element)
			curmod.ConvertSelection subarr[subobjectlevel] subarr[sublev] requireAll:isShift
		)
		else if keyboard.shiftpressed and subobjectlevel != 0 do
		(
			max modify mode
			curmod = Modpanel.getcurrentObject()
			subarr = #(#Vertex, #Edge, #Border, #Face, #Element)
			curmod.ConvertSelectionToBorder subarr[subobjectlevel] subarr[sublev]
		)
		subobjectlevel = sublev
	)
),

fn ESplineSubobjectSwitch sublev =
(
	local sceneUtils = Ribbon_Modeling.GetCachedManagedServicesSceneUtilities()
	local keepGoing = true
	
	if (sublev > 0) do
	(
		local isEditSpline = sceneUtils.IsSingleEditableSplineObjectSelected()
		local isEditSplineMod = sceneUtils.IsSingleEditSplineModifierSelected()
		if not isEditSpline and not isEditSplineMod do
		(
			if not mcrUtils.ValidMod Edit_Spline
			then keepGoing = false
			else AddMod Edit_Spline
		)
	)
	
	if keepGoing do
	(
		subobjectlevel = sublev
	)
),

-- Update UI
fn UpdateUI =
(
	UpdateToolbarButtons()
),

-- Soft Selection
fn SSToggle onOff =
(
	if ( Ribbon_Modeling.ValidSOMode() ) then
	(
		curmod = Modpanel.getcurrentObject()
		curmod.useSoftSel = onoff		
	)
),

fn IsSoftSelection =
(
	curmod = Modpanel.getcurrentObject()
	if curmod == undefined then false
	else Ribbon_Modeling.ValidSOMode() and (curmod.useSoftSel)
),

-- NURMS
fn NURMSToggle onOff =
(
	if ( Ribbon_Modeling.IsEditablePoly() ) then
	(
		curmod = Modpanel.getcurrentObject()
		curmod.surfSubdivide = onoff		
	)
),

fn IsNURMSOn =
(
	curmod = Modpanel.getcurrentObject()
	(Ribbon_Modeling.IsEditablePoly() and curmod.surfSubdivide)
),

-- Displacement
fn DisplacementToggle onOff =
(
	if ( Ribbon_Modeling.IsEditablePoly() ) then
	(
		curmod = Modpanel.getcurrentObject()
		curmod.useSubdivisionDisplacement = onoff		
	)
),

fn IsDisplacementOn =
(
	curmod = Modpanel.getcurrentObject()
	(Ribbon_Modeling.IsEditablePoly() and curmod.useSubdivisionDisplacement)
),

-- NURMS - Sep by Smoothgroups
fn NURMSSepBySmoothingGroups onOff =
(
	if ( Ribbon_Modeling.IsEditablePoly() ) then
	(
		curmod = Modpanel.getcurrentObject()
		curmod.sepBySmGroups = onoff		
	)
	
),

-- NURMS - Sep by Mats
fn NURMSSepByMats onOff =
(
	if ( Ribbon_Modeling.IsEditablePoly() ) then
	(
		curmod = Modpanel.getcurrentObject()
		curmod.sepByMats = onoff		
	)
	
),

-- Paint Direction
fn PaintDefaultDirection iDir =
(
	if ( Ribbon_Modeling.IsEditablePoly() ) then
	(
		curmod = Modpanel.getcurrentObject()
		curmod.paintDeformAxis = iDir		
	)
),

-- Paint SS Mode
fn PaintSSMode iMode =
(
	if ( Ribbon_Modeling.ValidSOMode() ) then
	(
		curmod = Modpanel.getcurrentObject()
		curmod.paintselmode = iMode		
	)
),

-- Is Paint SS Mode =
fn IsPaintSSMode =
(
	curmod = Modpanel.getcurrentObject()
	(Ribbon_Modeling.ValidSOMode() and (curmod.paintselmode != 0))
),

-- Turns on Edit Soft selection mode
fn EditSoftSelectionMode =
(
	Ribbon_Modeling.PaintSSMode 0
	if ( Ribbon_Modeling.ValidSelection() ) do
	(
		if ( Ribbon_Modeling.IsEditablePoly() ) then actionMan.executeAction 369982487 "41016" --Editable Poly  Edit Soft Selection Mode
		else actionMan.executeAction 1250838234 "40119" --Edit Poly  Edit Soft Selection Mode
	)
),
-- Are we in Edit Soft selection mode
fn IsEditSoftSelectionMode =
(
	bRet = false
	if ( Ribbon_Modeling.ValidSelection() and  ((toolMode.CommandMode == #modify) and (toolMode.CommandModeId == 525)) ) do
	(
		bRet = true
	)
	bRet
),
-- PaintDeform Mode
fn PaintDeformMode iMode =
(
	if ( Ribbon_Modeling.ValidSelection() ) then
	(
		curmod = Modpanel.getcurrentObject()
		curmod.paintdeformmode = iMode		
	)
),

fn ColorToPoint3 cColor =
(
	local p3Color = (Point3 0.0 0.0 0.0)
	p3Color.x = cColor.r / 255.0
	p3Color.y = cColor.g / 255.0
	p3Color.z = cColor.b / 255.0		
	p3Color
),

fn Point3ToColor p3Color =
(
	local cColor = (Color 0 0 0)
	cColor.r = p3Color.x * 255.0
	cColor.g = p3Color.y * 255.0
	cColor.b = p3Color.z * 255.0
	cColor
),

fn CurrentConstraintsIndex =
(
	if( Ribbon_Modeling.ValidSelection() ) then
	(
		curmod = Modpanel.getcurrentObject()
		curmod.constrainType + 1
	)
	else 1
),

fn SetVertexColor v type =
(
	if( Ribbon_Modeling.IsEditablePoly() ) do
	(	
		curmod = Modpanel.getcurrentObject()
		if( Ribbon_Modeling.GetSOEnum() == #Vertex ) then
			curmod.setVertexColor v type
		else
			curmod.setFaceColor v type
	)
),

fn GetVertexColor type =
(
	local ret = color 0 0 0
	if( Ribbon_Modeling.IsEditablePoly() ) do
	(
		curmod = Modpanel.getcurrentObject()
		if( Ribbon_Modeling.GetSOEnum() == #Vertex ) then	
			ret = curmod.getVertexColor type
		else
			ret = curmod.getFaceColor type
	)
	ret
),

fn GetModifyButtonText = 
(	
	result = ""
	if (selection.count == 1) then
	(
		curmod = Modpanel.getcurrentObject()
		if curmod == undefined then
		(
			result = ~MODIFY_MODE~
		)			
		else if curmod == $.baseobject and 
			classof curmod == Editable_Poly then
		(
			result = ~EDITABLE_POLY~
		)
		else if ( (superclassof curmod == modifier) or
			(superclassof curmod == SpacewarpModifier) ) then
		(
			modindex = modPanel.getModifierIndex $ curmod
			if modindex != undefined then
			(
				modnumm = (abs ($.modifiers.count - modindex)) + 1
				result = (modnumm as string) + ": " + $.modifiers[modindex].name
			)
		)
	)
	
	result
),

-- Retuns the given modifier's index within the given object's modifier array
-- or undefined if the modifier is not found.  This is used instead of 
-- modPanel.getModifierIndex because that function throws an exception if
-- you pass in anything but a Modifier or SpaceWarpModifier.  We don't want
-- to have to bother with type checking.
fn FindModifierIndex modif obj =
(
	result = undefined
	if(undefined != modif and undefined != obj) then
	(
		i = 1
		while (i <= obj.modifiers.count and undefined == result) do
		(
			if obj.modifiers[i] == modif then
			(
				result = i
			)
			i += 1
		)
	)
	
	result
)

)


--------------------------------------------------------------------
---
--- Soft Selection Spinners
---
--------------------------------------------------------------------
struct SS_FallOff_Spinner
(
	fn IsEnabled = 
	(
		Ribbon_Modeling.ValidSOMode()
	),
	fn OnChanged Value =
	(
		if( Ribbon_Modeling.ValidSOMode() ) do
		(
			curmod = Modpanel.getcurrentObject()
			curmod.falloff = Value
		)
	),
	fn GetValue =
	(
		local result = 0.0
		if( Ribbon_Modeling.ValidSOMode() ) do
		(
			curmod = Modpanel.getcurrentObject()
			result = curmod.falloff
		)
		result
	),
	fn Controller =
	(
		if( Ribbon_Modeling.ValidSOMode() ) do
		(
			curmod = Modpanel.getcurrentObject()
			curmod.falloff.controller
		)
	)
)

struct SS_Pinch_Spinner
(
	fn IsEnabled = 
	(
		Ribbon_Modeling.ValidSOMode()
	),
	fn OnChanged Value =
	(
		if( Ribbon_Modeling.ValidSOMode() ) do
		(
			curmod = Modpanel.getcurrentObject()
			curmod.pinch = Value
		)
	),
	fn GetValue =
	(
		local result = 0.0
		if( Ribbon_Modeling.ValidSOMode() ) do
		(
			curmod = Modpanel.getcurrentObject()
			result = curmod.pinch
		)
		result
	),
	fn Controller =
	(
		if( Ribbon_Modeling.ValidSOMode() ) do
		(
			curmod = Modpanel.getcurrentObject()
			curmod.pinch.controller
		)
	)
)

struct SS_Bubble_Spinner
(
	fn IsEnabled = 
	(
		Ribbon_Modeling.ValidSOMode()
	),
	fn OnChanged Value =
	(
		if( Ribbon_Modeling.ValidSOMode() ) do
		(
			curmod = Modpanel.getcurrentObject()
			curmod.bubble = Value
		)
	),
	fn GetValue =
	(
		local result = 0.0
		if( Ribbon_Modeling.ValidSOMode() ) do
		(
			curmod = Modpanel.getcurrentObject()
			result = curmod.bubble
		)
		result
	),
	fn Controller =
	(
		if( Ribbon_Modeling.ValidSOMode() ) do
		(
			curmod = Modpanel.getcurrentObject()
			curmod.bubble.controller
		)
	)
)

struct SS_EdgeDist_Spinner
(
	fn IsEnabled = 
	(
		Ribbon_Modeling.ValidSOMode()
	),
	fn OnChanged Value =
	(
		if( Ribbon_Modeling.ValidSOMode() ) do
		(
			curmod = Modpanel.getcurrentObject()
			curmod.ssEdgeDist = Value
		)
	),
	fn GetValue =
	(
		local result = 0.0
		if( Ribbon_Modeling.ValidSOMode() ) do
		(
			curmod = Modpanel.getcurrentObject()
			result = curmod.ssEdgeDist
		)
		result
	),
	fn Controller =
	(
		if( Ribbon_Modeling.ValidSOMode() ) do
		(
			curmod = Modpanel.getcurrentObject()
			curmod.ssEdgeDist.controller
		)
	)
)

struct SS_PaintValue_Spinner
(
	fn IsEnabled = 
	(
		Ribbon_Modeling.ValidSOMode()
	),
	fn OnChanged Value =
	(
		if( Ribbon_Modeling.ValidSOMode() ) do
		(
			curmod = Modpanel.getcurrentObject()
			curmod.paintSelValue = Value
		)
	),
	fn GetValue =
	(
		local result = 0.0
		if( Ribbon_Modeling.ValidSOMode() ) do
		(
			curmod = Modpanel.getcurrentObject()
			result = curmod.paintSelValue
		)
		result
	),
	fn Controller =
	(
		if( Ribbon_Modeling.ValidSOMode() ) do
		(
			curmod = Modpanel.getcurrentObject()
			curmod.paintSelValue.controller
		)
	)
)

struct SS_PaintSize_Spinner
(
	fn IsEnabled = 
	(
		Ribbon_Modeling.ValidSOMode()
	),
	fn OnChanged Value =
	(
		if( Ribbon_Modeling.ValidSOMode() ) do
		(
			curmod = Modpanel.getcurrentObject()
			curmod.paintSelSize = Value
		)
	),
	fn GetValue =
	(
		local result = 0.0
		if( Ribbon_Modeling.ValidSOMode() ) do
		(
			curmod = Modpanel.getcurrentObject()
			result = curmod.paintSelSize
		)
		result
	),
	fn Controller =
	(
		if( Ribbon_Modeling.ValidSOMode() ) do
		(
			curmod = Modpanel.getcurrentObject()
			curmod.paintSelSize.controller
		)
	)
)

struct SS_PaintStrength_Spinner
(
	fn IsEnabled = 
	(
		Ribbon_Modeling.ValidSOMode()
	),
	fn OnChanged Value =
	(
		if( Ribbon_Modeling.ValidSOMode() ) do
		(
			curmod = Modpanel.getcurrentObject()
			curmod.paintSelStrength = Value
		)
	),
	fn GetValue =
	(
		local result = 0.0
		if( Ribbon_Modeling.ValidSOMode() ) do
		(
			curmod = Modpanel.getcurrentObject()
			result = curmod.paintSelStrength
		)
		result
	),
	fn Controller =
	(
		if( Ribbon_Modeling.ValidSOMode() ) do
		(
			curmod = Modpanel.getcurrentObject()
			curmod.paintSelStrength.controller
		)
	)
)

struct NURMS_Iterations_Spinner
(
	fn IsEnabled = 
	(
		Ribbon_Modeling.IsEditablePoly()
	),
	fn OnChanged Value =
	(
		if( Ribbon_Modeling.IsEditablePoly() ) do
		(
			curmod = Modpanel.getcurrentObject()
			curmod.iterations = Value
		)
	),
	fn GetValue =
	(
		local result = 0
		if( Ribbon_Modeling.IsEditablePoly() ) do
		(
			curmod = Modpanel.getcurrentObject()
			result = curmod.iterations
		)
		result
	),
	fn Controller =
	(
		if( Ribbon_Modeling.ValidSOMode() ) do
		(
			curmod = Modpanel.getcurrentObject()
			curmod.iterations.controller
		)
	)
)

struct NURMS_Smoothness_Spinner
(
	fn IsEnabled = 
	(
		Ribbon_Modeling.IsEditablePoly()
	),
	fn OnChanged Value =
	(
		if( Ribbon_Modeling.IsEditablePoly() ) do
		(
			curmod = Modpanel.getcurrentObject()
			curmod.surfaceSmoothness = Value
		)
	),
	fn GetValue =
	(
		local result = 0.0
		if( Ribbon_Modeling.IsEditablePoly() ) do
		(
			curmod = Modpanel.getcurrentObject()
			result = curmod.surfaceSmoothness
		)
		result
	),
	fn Controller =
	(
		if( Ribbon_Modeling.ValidSOMode() ) do
		(
			curmod = Modpanel.getcurrentObject()
			curmod.surfaceSmoothness.controller
		)
	)
)

struct NURMS_Cage_ColorSwatch
(
	fn IsEnabled = 
	(
		Ribbon_Modeling.IsEditablePoly()
	),
	fn OnChanged Value =
	(
		if( Ribbon_Modeling.IsEditablePoly() ) do
		(	
			curmod = Modpanel.getcurrentObject()
			curmod.cageColor = (Ribbon_Modeling.ColorToPoint3 Value)
		)
	),
	fn GetValue =
	(
		local result = color 0 0 0
		if( Ribbon_Modeling.IsEditablePoly() ) do
		(
			curmod = Modpanel.getcurrentObject()
			result = (Ribbon_Modeling.Point3ToColor (curmod.cageColor))
		)
		result
	),
	fn Controller =
	(
		if( Ribbon_Modeling.ValidSOMode() ) do
		(
			curmod = Modpanel.getcurrentObject()
			curmod.cageColor.controller
		)
	)
)

struct NURMS_CageSelected_ColorSwatch
(
	fn IsEnabled = 
	(
		Ribbon_Modeling.IsEditablePoly()
	),
	fn OnChanged Value =
	(
		if( Ribbon_Modeling.IsEditablePoly() ) do
		(	
			curmod = Modpanel.getcurrentObject()
			curmod.selectedCageColor = (Ribbon_Modeling.ColorToPoint3 Value)
		)
	),
	fn GetValue =
	(
		local result = color 0 0 0
		if( Ribbon_Modeling.IsEditablePoly() ) do
		(
			curmod = Modpanel.getcurrentObject()
			result = (Ribbon_Modeling.Point3ToColor (curmod.selectedCageColor))
		)
		result
	),
	fn Controller =
	(
		if( Ribbon_Modeling.ValidSOMode() ) do
		(
			curmod = Modpanel.getcurrentObject()
			curmod.selectedCageColor.controller
		)
	)
)

struct NURMS_RenderIterations_Spinner
(
	fn IsEnabled = 
	(
		Ribbon_Modeling.IsEditablePoly()
	),
	fn OnChanged Value =
	(
		if( Ribbon_Modeling.IsEditablePoly() ) do
		(
			curmod = Modpanel.getcurrentObject()
			curmod.renderIterations = Value
		)
	),
	fn GetValue =
	(
		local result = 0
		if( Ribbon_Modeling.IsEditablePoly() ) do
		(
			curmod = Modpanel.getcurrentObject()
			result = curmod.renderIterations
		)
		result
	),
	fn Controller =
	(
		if( Ribbon_Modeling.ValidSOMode() ) do
		(
			curmod = Modpanel.getcurrentObject()
			curmod.renderIterations.controller
		)
	)
)

struct NURMS_RenderSmoothness_Spinner
(
	fn IsEnabled = 
	(
		Ribbon_Modeling.IsEditablePoly()
	),
	fn OnChanged Value =
	(
		if( Ribbon_Modeling.IsEditablePoly() ) do
		(
			curmod = Modpanel.getcurrentObject()
			curmod.renderSmoothness = Value
		)
	),
	fn GetValue =
	(
		local result = 0.0
		if( Ribbon_Modeling.IsEditablePoly() ) do
		(
			curmod = Modpanel.getcurrentObject()
			result = curmod.renderSmoothness
		)
		result
	),
	fn Controller =
	(
		if( Ribbon_Modeling.ValidSOMode() ) do
		(
			curmod = Modpanel.getcurrentObject()
			curmod.renderSmoothness.controller
		)
	)
)

struct Disp_Steps_Spinner
(
	fn IsEnabled = 
	(
		Ribbon_Modeling.IsEditablePoly()
	),
	fn OnChanged Value =
	(
		if( Ribbon_Modeling.IsEditablePoly() ) do
		(
			curmod = Modpanel.getcurrentObject()
			curmod.displaceSteps = Value
		)
	),
	fn GetValue =
	(
		local result = 0.0
		if( Ribbon_Modeling.IsEditablePoly() ) do
		(
			curmod = Modpanel.getcurrentObject()
			result = curmod.displaceSteps
		)
		result
	),
	fn Controller =
	(
		if( Ribbon_Modeling.ValidSOMode() ) do
		(
			curmod = Modpanel.getcurrentObject()
			curmod.displaceSteps.controller
		)
	)
)

struct Disp_Edge_Spinner
(
	fn IsEnabled = 
	(
		Ribbon_Modeling.IsEditablePoly()
	),
	fn OnChanged Value =
	(
		if( Ribbon_Modeling.IsEditablePoly() ) do
		(
			curmod = Modpanel.getcurrentObject()
			curmod.displaceEdge = Value
		)
	),
	fn GetValue =
	(
		local result = 0.0
		if( Ribbon_Modeling.IsEditablePoly() ) do
		(
			curmod = Modpanel.getcurrentObject()
			result = curmod.displaceEdge
		)
		result
	),
	fn Controller =
	(
		if( Ribbon_Modeling.ValidSOMode() ) do
		(
			curmod = Modpanel.getcurrentObject()
			curmod.displaceEdge.controller
		)
	)
)

struct Disp_Distance_Spinner
(
	fn IsEnabled = 
	(
		Ribbon_Modeling.IsEditablePoly()
	),
	fn OnChanged Value =
	(
		if( Ribbon_Modeling.IsEditablePoly() ) do
		(
			curmod = Modpanel.getcurrentObject()
			curmod.displaceDistance = Value
		)
	),
	fn GetValue =
	(
		local result = 0.0
		if( Ribbon_Modeling.IsEditablePoly() ) do
		(
			curmod = Modpanel.getcurrentObject()
			result = curmod.displaceDistance
		)
		result
	),
	fn Controller =
	(
		if( Ribbon_Modeling.ValidSOMode() ) do
		(
			curmod = Modpanel.getcurrentObject()
			curmod.displaceDistance.controller
		)
	)
)
struct Disp_Angle_Spinner
(
	fn IsEnabled = 
	(
		Ribbon_Modeling.IsEditablePoly()
	),
	fn OnChanged Value =
	(
		if( Ribbon_Modeling.IsEditablePoly() ) do
		(
			curmod = Modpanel.getcurrentObject()
			curmod.displaceAngle = Value
		)
	),
	fn GetValue =
	(
		local result = 0.0
		if( Ribbon_Modeling.IsEditablePoly() ) do
		(
			curmod = Modpanel.getcurrentObject()
			result = curmod.displaceAngle
		)
		result
	),
	fn Controller =
	(
		if( Ribbon_Modeling.ValidSOMode() ) do
		(
			curmod = Modpanel.getcurrentObject()
			curmod.displaceAngle.controller
		)
	)
)

struct Paint_PaintValue_Spinner
(
	fn IsEnabled = 
	(
		Ribbon_Modeling.ValidSOMode()
	),
	fn OnChanged Value =
	(
		if( Ribbon_Modeling.ValidSOMode() ) do
		(
			curmod = Modpanel.getcurrentObject()
			curmod.paintDeformValue = Value
		)
	),
	fn GetValue =
	(
		local result = 0.0
		if( Ribbon_Modeling.ValidSOMode() ) do
		(
			curmod = Modpanel.getcurrentObject()
			result = curmod.paintDeformValue
		)
		result
	),
	fn Controller =
	(
		if( Ribbon_Modeling.ValidSOMode() ) do
		(
			curmod = Modpanel.getcurrentObject()
			curmod.paintDeformValue.controller
		)
	)
)

struct Paint_PaintSize_Spinner
(
	fn IsEnabled = 
	(
		Ribbon_Modeling.ValidSOMode()
	),
	fn OnChanged Value =
	(
		if( Ribbon_Modeling.ValidSOMode() ) do
		(
			curmod = Modpanel.getcurrentObject()
			curmod.paintDeformSize = Value
		)
	),
	fn GetValue =
	(
		local result = 0.0
		if( Ribbon_Modeling.ValidSOMode() ) do
		(
			curmod = Modpanel.getcurrentObject()
			result = curmod.paintDeformSize
		)
		result
	),
	fn Controller =
	(
		if( Ribbon_Modeling.ValidSOMode() ) do
		(
			curmod = Modpanel.getcurrentObject()
			curmod.paintDeformSize.controller
		)
	)
)

struct Paint_PaintStrength_Spinner
(
	fn IsEnabled = 
	(
		Ribbon_Modeling.ValidSOMode()
	),
	fn OnChanged Value =
	(
		if( Ribbon_Modeling.ValidSOMode() ) do
		(
			curmod = Modpanel.getcurrentObject()
			curmod.paintDeformStrength = Value
		)
	),
	fn GetValue =
	(
		local result = 0.0
		if( Ribbon_Modeling.ValidSOMode() ) do
		(
			curmod = Modpanel.getcurrentObject()
			result = curmod.paintDeformStrength
		)
		result
	),
	fn Controller =
	(
		if( Ribbon_Modeling.ValidSOMode() ) do
		(
			curmod = Modpanel.getcurrentObject()
			curmod.paintDeformStrength.controller
		)
	)
)

struct VertexSelect_ColorSwatch
(
	fn IsEnabled = 
	(
		Ribbon_Modeling.IsEditablePoly()
	),
	fn OnChanged Value =
	(
		if( Ribbon_Modeling.IsEditablePoly() ) do
		(	
			curmod = Modpanel.getcurrentObject()
			curmod.vertSelectionColor = Value
		)
	),
	fn GetValue =
	(
		local result = color 0 0 0
		if( Ribbon_Modeling.IsEditablePoly() ) do
		(
			curmod = Modpanel.getcurrentObject()
			result = curmod.vertSelectionColor
		)
		result
	),
	fn Controller =
	(
		if( Ribbon_Modeling.ValidSOMode() ) do
		(
			curmod = Modpanel.getcurrentObject()
			curmod.vertSelectionColor.controller
		)
	)
)

struct VertexSelect_R_Spinner
(
	fn IsEnabled = 
	(
		Ribbon_Modeling.IsEditablePoly()
	),
	fn OnChanged Value =
	(
		if( Ribbon_Modeling.IsEditablePoly() ) do
		(
			curmod = Modpanel.getcurrentObject()
			curmod.vertSelectionRedRange = Value
		)
	),
	fn GetValue =
	(
		local result = 0
		if( Ribbon_Modeling.IsEditablePoly() ) do
		(
			curmod = Modpanel.getcurrentObject()
			result = curmod.vertSelectionRedRange
		)
		result
	),
	fn Controller =
	(
		if( Ribbon_Modeling.ValidSOMode() ) do
		(
			curmod = Modpanel.getcurrentObject()
			curmod.vertSelectionRedRange.controller
		)
	)
)

struct VertexSelect_G_Spinner
(
	fn IsEnabled = 
	(
		Ribbon_Modeling.IsEditablePoly()
	),
	fn OnChanged Value =
	(
		if( Ribbon_Modeling.IsEditablePoly() ) do
		(
			curmod = Modpanel.getcurrentObject()
			curmod.vertSelectionGreenRange = Value
		)
	),
	fn GetValue =
	(
		local result = 0
		if( Ribbon_Modeling.IsEditablePoly() ) do
		(
			curmod = Modpanel.getcurrentObject()
			result = curmod.vertSelectionGreenRange
		)
		result
	),
	fn Controller =
	(
		if( Ribbon_Modeling.ValidSOMode() ) do
		(
			curmod = Modpanel.getcurrentObject()
			curmod.vertSelectionGreenRange.controller
		)
	)
)

struct VertexSelect_B_Spinner
(
	fn IsEnabled = 
	(
		Ribbon_Modeling.IsEditablePoly()
	),
	fn OnChanged Value =
	(
		if( Ribbon_Modeling.IsEditablePoly() ) do
		(
			curmod = Modpanel.getcurrentObject()
			curmod.vertSelectionBlueRange = Value
		)
	),
	fn GetValue =
	(
		local result = 0
		if( Ribbon_Modeling.IsEditablePoly() ) do
		(
			curmod = Modpanel.getcurrentObject()
			result = curmod.vertSelectionBlueRange
		)
		result
	),
	fn Controller =
	(
		if( Ribbon_Modeling.ValidSOMode() ) do
		(
			curmod = Modpanel.getcurrentObject()
			curmod.vertSelectionBlueRange.controller
		)
	)
)

struct Vertex_Weight_Spinner
(
	fn IsEnabled = 
	(
		(Ribbon_Modeling.IsEditablePoly() and (subobjectlevel == 1))
	),
	fn OnChanged Value =
	(
		if( Ribbon_Modeling.IsEditablePoly() and (subobjectlevel == 1) ) do
		(
			curmod = Modpanel.getcurrentObject()
			curmod.SetVertexData 1 Value
		)
	),
	fn GetValue =
	(
		local result = 0.0
		if( Ribbon_Modeling.IsEditablePoly() and (subobjectlevel == 1) ) do
		(
			numSel = 1
			uniform = false
			curmod = Modpanel.getcurrentObject()
			result = curmod.getVertexData 1 &numsel &uniform
		)
		result
	)
)

struct Vertex_Crease_Spinner
(
	fn IsEnabled = 
	(
		(Ribbon_Modeling.IsEditablePoly() and (subobjectlevel == 1))
	),
	fn OnChanged Value =
	(
		if( Ribbon_Modeling.IsEditablePoly() and (subobjectlevel == 1) ) do
		(
			curmod = Modpanel.getcurrentObject()
			curmod.SetVertexData 4 Value
		)
	),
	fn GetValue =
	(
		local result = 0.0
		if( Ribbon_Modeling.IsEditablePoly() and (subobjectlevel == 1) ) do
		(
			numSel = 1
			uniform = false
			curmod = Modpanel.getcurrentObject()
			result = curmod.getVertexData 4 &numsel &uniform
		)
		result
	)
)

struct Edge_Weight_Spinner
(
	fn IsEnabled = 
	(
		(Ribbon_Modeling.IsEditablePoly() and Ribbon_Modeling.IsEdgeMode())
	),
	fn OnChanged Value =
	(
		if( Ribbon_Modeling.IsEditablePoly() and Ribbon_Modeling.IsEdgeMode() ) do
		(
			curmod = Modpanel.getcurrentObject()
			curmod.SetEdgeData 0 Value
		)
	),
	fn GetValue =
	(
		local result = 0.0
		if( Ribbon_Modeling.IsEditablePoly() and Ribbon_Modeling.IsEdgeMode()) do
		(
			numSel = 1
			uniform = false
			curmod = Modpanel.getcurrentObject()
			result = curmod.getEdgeData 0 &numsel &uniform
		)
		result
	)
)

struct Edge_Crease_Spinner
(
	fn IsEnabled = 
	(
		(Ribbon_Modeling.IsEditablePoly() and Ribbon_Modeling.IsEdgeMode())
	),
	fn OnChanged Value =
	(
		if( Ribbon_Modeling.IsEditablePoly() and Ribbon_Modeling.IsEdgeMode()) do
		(
			curmod = Modpanel.getcurrentObject()
			curmod.SetEdgeData 1 Value
		)
	),
	fn GetValue =
	(
		local result = 0.0
		if( Ribbon_Modeling.IsEditablePoly() and Ribbon_Modeling.IsEdgeMode() ) do
		(
			numSel = 1
			uniform = false
			curmod = Modpanel.getcurrentObject()
			result = curmod.getEdgeData 1 &numsel &uniform
		)
		result
	)
)

struct Edge_Depth_Spinner
(
	fn IsEnabled = 
	(
		(Ribbon_Modeling.IsEditablePoly() and Ribbon_Modeling.IsEdgeMode())
	),
	fn OnChanged Value =
	(
		if( Ribbon_Modeling.IsEditablePoly() and Ribbon_Modeling.IsEdgeMode()) do
		(
			curmod = Modpanel.getcurrentObject()
			curmod.SetEdgeData 3 Value
		)
	),
	fn GetValue =
	(
		local result = 0.0
		if( Ribbon_Modeling.IsEditablePoly() and Ribbon_Modeling.IsEdgeMode() ) do
		(
			numSel = 1
			uniform = false
			curmod = Modpanel.getcurrentObject()
			result = curmod.getEdgeData 3 &numsel &uniform
		)
		result
	)
)

struct SetVertexColorColor_ColorSwatch
(
	fn IsEnabled = 
	(
		Ribbon_Modeling.IsEditablePoly()
	),
	fn OnChanged Value =
	(
		Ribbon_Modeling.SetVertexColor Value #vertexColor
	),
	fn GetValue =
	(
		Ribbon_Modeling.GetVertexColor #vertexColor
	)
)

struct SetVertexColorIllum_ColorSwatch
(
	fn IsEnabled = 
	(
		Ribbon_Modeling.IsEditablePoly()
	),
	fn OnChanged Value =
	(
		Ribbon_Modeling.SetVertexColor Value #illumination
	),
	fn GetValue =
	(
		Ribbon_Modeling.GetVertexColor #illumination
	)
)


struct SetVertexAlpha_Spinner
(
	fn IsEnabled = 
	(
		Ribbon_Modeling.IsEditablePoly()
	),
	fn OnChanged Value =
	(
			v = Value * 2.55
		Ribbon_Modeling.SetVertexColor (Color v v v) #Alpha
	),
	fn GetValue =
	(
		cColor = Ribbon_Modeling.GetVertexColor #Alpha
		cColor.r / 2.55
	)
)

struct SelectByAngleSpinnerCallback
(
	fn IsEnabled = 
	(
		-- Face mode only
		(Ribbon_Modeling.ValidSelection() and (subobjectlevel == 4))
	),
	fn OnChanged Value =
	(
		-- Face mode only
		if (Ribbon_Modeling.ValidSelection() and (subobjectlevel == 4)) do
		(
			curmod = Modpanel.getcurrentObject()
			curmod.selectAngle = Value
		)
	),
	fn GetValue =
	(
		-- Face mode only	
		if (Ribbon_Modeling.ValidSelection() and (subobjectlevel == 4)) then
		(
			curmod = Modpanel.getcurrentObject()
			curmod.selectAngle
		)
		else
		(
			0.0
		)
	)
)


-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQC0P8PtxNiOdvXY/B93Ulk4QVRRtGYViXOm
-- y3eWindx+ZrNyf0cFFhgJAo7QUBlbdLPHqojdRrFt4xvbz7d6JnCtu1ZeOVMZnO1
-- xfZDP80u2u6peEm3EijEa/QjNKzAWSrFUmy7w7qjRgV8AQJjM1UHjuJ1GnNA+U6r
-- JkyEmxdEOjo7+4EtDFfZaNLQcURT0/39xnm2hKaCS+zNk6iNqJyBLQ6/RYZoFULJ
-- FKkwzxUUSQSHIVNoUHlFj/9y5Ku6rUFAO8Nj8ozTr9ulI6EsW9nObBz+osD5MCUi
-- RKuZ3W/+mcwwmjdQa1O30SFZIqAtnJ9xvdjyxRjJo9/HB4PyzdQY
-- -----END-SIGNATURE-----